<?php

class PracownikController extends Controller
{
	public $layout = 'administration';
	public $defaultAction = 'admin';

	public function init()
	{
		Yii::import('application.modules.administration.controllers.MainController');
		$mainController = new MainController('main');
		$this->menu = $mainController->menu;
	}

	/**
	 * @return array action filters
	 */
	public function filters()
	{
		return array(
			'accessControl',
			'postOnly + delete',
		);
	}

	/**
	 * Specifies the access control rules.
	 * This method is used by the 'accessControl' filter.
	 * @return array access control rules
	 */
	public function accessRules()
	{
		return array(
			array('allow', // allow authenticated users to perform actions
				'actions'=>array('create','update','delete','admin','view'),
				'roles'=>array('admin')
			),
			array('deny',  // deny all users
				'users'=>array('*'),
			),
		);
	}

	/**
	 * Displays a particular model.
	 * @param integer $id the ID of the model to be displayed
	 */
	public function actionView($id)
	{
		$this->render('view', array(
			'model'=>$this->loadModel($id),
		));
	}

	/**
	 * Creates a new model.
	 * If creation is successful, the browser will be redirected to the 'view' page.
	 */
	public function actionCreate()
	{
		$model = new Pracownik;

		if(isset($_POST['Pracownik']))
		{
			$model->attributes = $_POST['Pracownik'];

			$model->image = CUploadedFile::getInstance($model,'image');

			//saving image in temporary folder
			if(!empty($model->image))
			{
				if (!file_exists('uploads/temp/'.$model->tempFolderName.'/'))
					mkdir('uploads/temp/'.$model->tempFolderName.'/', 0777, true);

				$model->image->saveAs('uploads/temp/'.$model->tempFolderName.'/'.$model->image->name);
				$model->tempImageName = $model->image->name;
			}

			if($model->save())
			{
				$employeeField = new DziedzinaPracownika();
				$employeeField->idPracownika = $model->id;
				$employeeField->idDziedziny = 1;
				$employeeField->save(false);

				$employeeField = new DziedzinaPracownika();
				$employeeField->idPracownika = $model->id;
				$employeeField->idDziedziny = 2;
				$employeeField->save(false);

				$employeeField = new DziedzinaPracownika();
				$employeeField->idPracownika = $model->id;
				$employeeField->idDziedziny = 3;
				$employeeField->save(false);

				$employeeField = new DziedzinaPracownika();
				$employeeField->idPracownika = $model->id;
				$employeeField->idDziedziny = 4;
				$employeeField->save(false);

				//image exists in temp dir
				if(!empty($model->tempImageName))
					$model->urlAvatara = 'uploads/employees/'.$model->id.'/'.$model->tempImageName;

				$model->save(false);

				//move a photo from the temp directory to a proper one
				if(!empty($model->tempImageName) && !empty($model->tempFolderName))
				{
					if (!file_exists('uploads/employees/'.$model->id))
						mkdir('uploads/employees/'.$model->id, 0777, true);

					copy('uploads/temp/'.$model->tempFolderName.'/'.$model->tempImageName, 'uploads/employees/'.$model->id.'/'.$model->tempImageName);
					unlink('uploads/temp/'.$model->tempFolderName.'/'.$model->tempImageName);
					//removing temp dir and its files
					foreach(scandir('uploads/temp/'.$model->tempFolderName) as $file)
							if(is_file('uploads/temp/'.$model->tempFolderName.'/'.$file))
									unlink('uploads/temp/'.$model->tempFolderName.'/'.$file);
					rmdir('uploads/temp/'.$model->tempFolderName);
				}
				$this->redirect(array('view', 'id'=>$model->id));
			}
		}
		else //at the start - generation unique temp folder name
		{
			$model->tempFolderName = uniqid();
			while(file_exists('uploads/temp/'.$model->tempFolderName))
			{
				$model->tempFolderName = uniqid();
			}
			mkdir('uploads/temp/'.$model->tempFolderName, 0777, true);
		}

		$this->render('create', array(
			'model'=>$model,
		));
	}

	/**
	 * Updates a particular model.
	 * If update is successful, the browser will be redirected to the 'view' page.
	 * @param integer $id the ID of the model to be updated
	 */
	public function actionUpdate($id)
	{
		$model = $this->loadModel($id);

		if(isset($_POST['Pracownik']))
		{
			
			$model->urlAvatara = $_POST['Pracownik']['urlAvatara'];
			Yii::log("!!!".$model->urlAvatara." - ".strstr($model->urlAvatara, "uploads"));
			
			$model->image=CUploadedFile::getInstance($model,'image');

			if(count($model->urlAvatara)<2 || strstr($model->urlAvatara, "uploads"))
			{
				if(!empty($model->image))
				{
					if(!file_exists('uploads/employees/'.$model->id))
						mkdir('uploads/employees/'.$model->id, 0777, true);

					//cleaning image dir
					foreach(scandir('uploads/employees/'.$model->id) as $file)
							if(is_file('uploads/employees/'.$model->id.'/'.$file))
									unlink('uploads/employees/'.$model->id.'/'.$file);

					$model->urlAvatara = 'uploads/employees/'.$model->id.'/'.$model->image->name;
					$model->image->saveAs('uploads/employees/'.$model->id.'/'.$model->image->name);

					$model->save(false);
				}
			}
			else
			{
				$model->save(false);
			}

			unset($_POST['Pracownik']['urlAvatara']);
			$model->attributes = $_POST['Pracownik'];

			if($model->save())
			{
				$this->redirect(array('view', 'id'=>$model->id));
			}
		}

		$this->render('update',array(
			'model'=>$model,
		));
	}

	/**
	 * Deletes a particular model.
	 * If deletion is successful, the browser will be redirected to the 'admin' page.
	 * @param integer $id the ID of the model to be deleted
	 */
	public function actionDelete($id)
	{
		try
		{
			$this->loadModel($id)->delete();
			if(!isset($_GET['ajax']))
				$this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('admin'));
		}
		catch(Exception $e)
		{
			throw new CHttpException(404, 'Nie można usunąć rekordu. Obiekt może być nierozerwalnie połączony z innymi elementami w bazie.');
		}
	}

	/**
	 * Manages all models.
	 */
	public function actionAdmin()
	{
		$model = new Pracownik('search');
		$model->unsetAttributes();

		if(isset($_GET['Pracownik']))
			$model->attributes = $_GET['Pracownik'];

		$this->render('admin', array(
			'model'=>$model,
		));
	}

	/**
	 * Returns the data model based on the primary key given in the GET variable.
	 * If the data model is not found, an HTTP exception will be raised.
	 * @param integer $id the ID of the model to be loaded
	 */
	public function loadModel($id)
	{
		$model = Pracownik::model()->with(array('dziedzina'))->findByPk($id);

		if($model === null)
			throw new CHttpException(404, Yii::t('The requested page does not exist.'));

		return $model;
	}
}